/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.entities.components.BehaviourComponent;
import technology.rocketjump.undermount.entities.factories.HumanoidEntityAttributesFactory;
import technology.rocketjump.undermount.entities.factories.HumanoidEntityFactory;
import technology.rocketjump.undermount.entities.factories.ItemEntityFactory;
import technology.rocketjump.undermount.entities.factories.PlantEntityAttributesFactory;
import technology.rocketjump.undermount.entities.factories.PlantEntityFactory;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemTypeDictionary;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.jobs.model.Profession;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.misc.VectorUtils;

public class EntityStore {
    private final HumanoidEntityFactory humanoidEntityFactory;
    private final HumanoidEntityAttributesFactory humanoidEntityAttributesFactory;
    private final PlantEntityAttributesFactory plantEntityAttributesFactory;
    private final PlantEntityFactory plantEntityFactory;
    private final ItemTypeDictionary itemTypeDictionary;
    private final ItemEntityFactory itemEntityFactory;
    private final Map<Long, Entity> allEntities = new ConcurrentHashMap<Long, Entity>();
    private final Map<Long, Entity> updateEveryFrameEntities = new ConcurrentHashMap<Long, Entity>();
    private final List<Entity> updateInfrequentlyEntities = new ArrayList<Entity>();
    private final Map<Long, Entity> jobAssignableEntities = new ConcurrentHashMap<Long, Entity>();
    private final MessageDispatcher messageDispatcher;

    @Inject
    public EntityStore(HumanoidEntityFactory humanoidEntityFactory, HumanoidEntityAttributesFactory humanoidEntityAttributesFactory, PlantEntityAttributesFactory plantEntityAttributesFactory, PlantEntityFactory plantEntityFactory, ItemTypeDictionary itemTypeDictionary, ItemEntityFactory itemEntityFactory, MessageDispatcher messageDispatcher) {
        this.humanoidEntityFactory = humanoidEntityFactory;
        this.humanoidEntityAttributesFactory = humanoidEntityAttributesFactory;
        this.plantEntityAttributesFactory = plantEntityAttributesFactory;
        this.plantEntityFactory = plantEntityFactory;
        this.itemTypeDictionary = itemTypeDictionary;
        this.itemEntityFactory = itemEntityFactory;
        this.messageDispatcher = messageDispatcher;
    }

    public void createHumanoid(Vector2 worldPosition, Vector2 facing, TiledMap map, Profession profession) {
        HumanoidEntityAttributes attributes = this.humanoidEntityAttributesFactory.create();
        Entity entity = this.humanoidEntityFactory.create(attributes, worldPosition, facing, map, profession);
        this.add(entity, map);
    }

    public void add(Entity entity, TiledMap map) {
        this.allEntities.put(entity.getId(), entity);
        if (entity.isUpdateEveryFrame()) {
            this.updateEveryFrameEntities.put(entity.getId(), entity);
        }
        if (entity.isUpdateInfrequently()) {
            this.updateInfrequentlyEntities.add(entity);
        }
        if (entity.isJobAssignable()) {
            this.jobAssignableEntities.put(entity.getId(), entity);
        }
        if (entity.getLocationComponent().getWorldPosition() != null) {
            GridPoint2 entityTilePosition = VectorUtils.toGridPoint(entity.getLocationComponent().getWorldPosition());
            map.getTile(entityTilePosition).addEntity(entity);
            for (GridPoint2 extraTilePosition : entity.calculateOtherTilePositions()) {
                map.getTile(extraTilePosition).addEntity(entity);
            }
        }
    }

    public Entity remove(long entityId) {
        Entity entityToRemove = this.allEntities.remove(entityId);
        if (entityToRemove != null) {
            if (entityToRemove.isUpdateEveryFrame()) {
                this.updateEveryFrameEntities.remove(entityId);
            }
            if (entityToRemove.isUpdateInfrequently()) {
                this.updateInfrequentlyEntities.remove(entityToRemove);
            }
        }
        return entityToRemove;
    }

    public void createTree(String speciesName, GridPoint2 worldPosition, TiledMap map) {
        PlantEntityAttributes treeAttributes = this.plantEntityAttributesFactory.randomTreeByName(speciesName);
        Entity entity = this.plantEntityFactory.create(treeAttributes, worldPosition, map);
        this.add(entity, map);
    }

    public void createShrub(String speciesName, GridPoint2 worldPosition, TiledMap map) {
        PlantEntityAttributes shrubAttributes = this.plantEntityAttributesFactory.randomShrubByName(speciesName);
        Entity entity = this.plantEntityFactory.create(shrubAttributes, worldPosition, map);
        this.add(entity, map);
    }

    public void changeBehaviour(Entity entity, BehaviourComponent newBehaviour, GameContext gameContext, MessageDispatcher messageDispatcher) {
        if (entity != null) {
            BehaviourComponent oldBehaviour = entity.getBehaviourComponent();
            if (oldBehaviour.isJobAssignable()) {
                this.jobAssignableEntities.remove(entity.getId());
            }
            if (oldBehaviour.isUpdateEveryFrame()) {
                this.updateEveryFrameEntities.remove(entity.getId());
            }
            if (oldBehaviour.isUpdateInfrequently()) {
                this.updateInfrequentlyEntities.remove(entity);
            }
            entity.setBehaviourComponent(newBehaviour);
            newBehaviour.init(entity, messageDispatcher, gameContext.getAreaMap());
            if (newBehaviour.isJobAssignable()) {
                this.jobAssignableEntities.put(entity.getId(), entity);
            }
            if (newBehaviour.isUpdateEveryFrame()) {
                this.updateEveryFrameEntities.put(entity.getId(), entity);
            }
            if (newBehaviour.isUpdateInfrequently()) {
                this.updateInfrequentlyEntities.add(entity);
            }
        }
    }

    public void createResourceItem(GameMaterial mainMaterial, GridPoint2 worldPosition, TiledMap map, Random random, int quantity, GameMaterial ... otherMaterials) {
        ItemEntityAttributes itemEntityAttributes = new ItemEntityAttributes(random.nextLong());
        switch (mainMaterial.getMaterialType()) {
            case STONE: {
                itemEntityAttributes.setItemType(this.itemTypeDictionary.getByName("Resource-Stone-Unrefined"));
                break;
            }
            case ORE: {
                itemEntityAttributes.setItemType(this.itemTypeDictionary.getByName("Resource-Ore-Unrefined"));
                break;
            }
            case GEM: {
                itemEntityAttributes.setItemType(this.itemTypeDictionary.getByName("Resource-Gems-Unrefined"));
                break;
            }
            default: {
                System.err.println("Not yet implemented resource item creation from " + (Object)((Object)mainMaterial.getMaterialType()));
                return;
            }
        }
        itemEntityAttributes.setMaterial(mainMaterial);
        for (GameMaterial otherMaterial : otherMaterials) {
            itemEntityAttributes.setMaterial(otherMaterial);
        }
        itemEntityAttributes.setQuantity(quantity);
        this.createResourceItem(itemEntityAttributes, worldPosition, map);
    }

    public void createResourceItem(ItemEntityAttributes itemEntityAttributes, GridPoint2 worldPosition, TiledMap map) {
        MapTile tile = map.getTile(worldPosition);
        if (tile != null) {
            Entity matchingItem = tile.getItemMatching(itemEntityAttributes);
            if (matchingItem == null) {
                Entity newEntity = this.itemEntityFactory.create(itemEntityAttributes, worldPosition, map);
                this.add(newEntity, map);
                this.messageDispatcher.dispatchMessage(null, 700, (Object)newEntity);
            } else {
                ItemEntityAttributes attributes = (ItemEntityAttributes)matchingItem.getPhysicalEntityComponent().getAttributes();
                attributes.setQuantity(attributes.getQuantity() + itemEntityAttributes.getQuantity());
            }
        }
    }

    public Iterable<Entity> getJobAssignableEntities() {
        return this.jobAssignableEntities.values();
    }

    public void shuffle() {
        Collections.shuffle(this.updateInfrequentlyEntities);
    }

    public Entity getById(long entityId) {
        return this.allEntities.get(entityId);
    }

    public Iterable<Entity> getAllEntities() {
        return this.allEntities.values();
    }

    public Iterable<Entity> getUpdateEveryFrameEntities() {
        return this.updateEveryFrameEntities.values();
    }

    public List<Entity> getUpdateInfrequentlyEntities() {
        return this.updateInfrequentlyEntities;
    }
}

